using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Xml.Serialization;

namespace SmartSync
{
    public class LogEntry
    {
        [XmlAttribute("type")]
        public int Type;
        [XmlAttribute("date")]
        public DateTime Date;
        [XmlAttribute("source")]
        public string Source;
        [XmlAttribute("description")]
        public String Description;

        public LogEntry()
        {
            Type = Logger.UNKNOWN;
            Date = DateTime.Now;
            Source = "";
            Description = "";
        }
        public LogEntry(int iType, String sSource, String sDescription)
        {
            Type = iType;
            Date = DateTime.Now;
            Source = sSource;
            Description = sDescription;
        }

        public String toXml()
        {
            String retval = "";
            retval += "<entry>\r\n";
            retval += "\t<type>" + System.Convert.ToString(Type) + "</type>\r\n";
            retval += "\t<source>" + Source + "</source>\r\n";
            retval += "\t<description>" + Description + "</description>\r\n";
            retval += "\t<timestamp>" + System.DateTime.Now.ToString() + "</timestamp>\r\n";
            retval += "</entry>\r\n";
            return retval;
        }
    }

    [XmlRoot("LogFile")]
    public class Logger
    {
        public static int UNKNOWN = 0;
        public static int INFO = 1;
        public static int NOTIFY = 2;
        public static int WARNING = 4;
        public static int USERACTION = 8;
        public static int ERROR = 16;
        public static int EXCEPTION = 64;

        private static int pvt_iLogLevel = 0;

        [XmlArray("Items")]
        [XmlArrayItem("item", typeof(ComparisonItem))]
        public static ArrayList Entries = new ArrayList();

        private static String getLogPath()
        {
            return AppSettings.getAppDir() + "\\logfile.xml";
        }

        public static void SetLogLevel(int iLevel)
        {
            pvt_iLogLevel = iLevel;
        }

        public static void AddEntry(int iType, String sSource, String sDescription)
        {
            try
            {
                if (iType < pvt_iLogLevel)
                    return;
                LogEntry entry = new LogEntry(iType, sSource, sDescription);
                //Entries.Add(entry);
                StringBuilder sb = new StringBuilder();
                System.IO.StreamWriter writer = new System.IO.StreamWriter(getLogPath(), true);
                writer.Write(entry.toXml());
                writer.Flush();
                writer.Close();
            }
            catch (Exception ex)
            {
            }
        }

    }
}
