// TODO Licence!

// ==========================================================================

/**
 * @type String
 */
const HTML_NS = "http://www.w3.org/1999/xhtml";

/**
 * @type Boolean
 */
var gShellInitialized = false;

/**
 * Main controlling object for JavaScript Shell window
 */
var gShell = {
  
  /**
   * @type Components.interfaces.nsIStringBundle
   */
  _strbundle: null,
  
  /**
   * @type Components.interfaces.nsIDOMElement
   */
  _output: null,
  
  /**
   * This not means only XPCOMViewer's window self but generally
   * the top-level scope of the shell.
   * @type Object
   */
  _window: null,
  
  /**
   * @type Array
   */
  histList: [""],
  
  /**
   * @type Number
   */
  histPos: 0,
  
  /**
   * @type String
   */
  question: null,
  
  /**
   * @type Object
   */
  tooManyMatches: null,
  
  /**
   * @type Object
   */
  lastError: null,
  
  /**
   * @type Object
   */
  scope: {},
  
  /**
   * @type Object
   */
  commands: {
    load : function(url) {
      var s = gShell._window.document.createElement("script");
      s.type = "text/javascript";
      s.src = url;
      gShell._window.document.getElementsByTagName("head")[0].appendChild(s);
      gShell.println("Loading " + url + "...", "message");
    },
    
    clear : function() {
      var CHILDREN_TO_PRESERVE = 3;
      while(gShell._output.childNodes[CHILDREN_TO_PRESERVE]) {
        gShell._output.removeChild(gShell._output.childNodes[CHILDREN_TO_PRESERVE]);
      }
    },
    
    print : function(s) {
      gShell.println(s, "print");
    },
    
    // the normal function, "print", shouldn't return a value
    // (suggested by brendan; later noticed it was a problem when showing others)
    pr : function(s) { 
      gShell.commands.print(s);
      return s;
    },
    
    props : function(e, onePerLine) {
      if(e === null) {
        gShell.println("props called with null argument", "error");
        return;
      }
      
      if(e === undefined) {
        gShell.println("props called with undefined argument", "error");
        return;
      }
      
      var ns = ["Methods", "Fields", "Unreachables"];
      var as = [[], [], []]; // array of (empty) arrays of arrays!
      var p, j, i; // loop variables, several used multiple times
      var protoLevels = 0;
      
      for(p = e; p; p = p.__proto__) {
        for(i=0; i<ns.length; ++i) {
          as[i][protoLevels] = [];
        }
        ++protoLevels;
      }
      
      for(var a in e) {
        // TODO: Shortcoming: doesn't check that VALUES are the same in object and prototype.
        var protoLevel = -1;
        try {
          for(p = e; p && (a in p); p = p.__proto__) {
            ++protoLevel;
          }
        } catch(er) {
          protoLevel = 0;
          // "in" operator throws when param to props() is a string
        }
        
        var type = 1;
        try {
          if((typeof e[a]) == "function") {
            type = 0;
          }
        } catch(er) {
          type = 2;
        }
        
        as[type][protoLevel].push(a);
      }
      
      function times(s, n) { return n ? s + times(s, n-1) : ""; }
      
      for(j=0; j<protoLevels; ++j) {
        for(i=0;i<ns.length;++i) {
          if(as[i][j].length) {
            gShell.printWithRunin(
              ns[i] + times(" of prototype", j), 
              (onePerLine ? "\n\n" : "") + as[i][j].sort().join(onePerLine ? "\n" : ", ") + (onePerLine ? "\n\n" : ""), 
              "propList"
            );
          }
        }
      }
    },
    
    blink : function(node) {
      if(!node)                 throw("blink: argument is null or undefined.");
      if(node.nodeType == null) throw("blink: argument must be a node.");
      if(node.nodeType == 3)    throw("blink: argument must not be a text node");
      if(node.documentElement)  throw("blink: argument must not be the document object");
      
      function setOutline(o){ return function(){ node.style.outline = o; }; };
      function focusIt(a){ return function(){ a.focus(); }; };
    
      if(node.ownerDocument) {
        var windowToFocusNow = node.ownerDocument.defaultView;
        if(windowToFocusNow) {
          setTimeout(focusIt(windowToFocusNow.top), 0);
        }
      }
      
      for(var i=1; i<7; ++i) {
        setTimeout(setOutline((i%2)?'3px solid red':'none'), i*100);
      }
      
      setTimeout(focusIt(window), 800);
      setTimeout(function(){ focusIt(document.getElementById("input")); }, 810);
    },
    
    scope: function(sc) {
      if(!sc) sc = {};
      
      gShell.scope = sc;
      gShell.println("Scope is now " + sc + ".  If a variable is not found in this scope, window will also be searched.  New variables will still go on window.", "message");
    },
    
    mathHelp: function() {
      gShell.printWithRunin("Math constants", "E, LN2, LN10, LOG2E, LOG10E, PI, SQRT1_2, SQRT2", "propList");
      gShell.printWithRunin("Math methods", "abs, acos, asin, atan, atan2, ceil, cos, exp, floor, log, max, min, pow, random, round, sin, sqrt, tan", "propList");
    },
    
    ansHelp: function() {
      gShell.println("ans", "The result of the previous expression.", "message");
    },
    
    prHelp: function() {},
    printHelp: function() {},
    propsHelp: function() {},
    
    blinkHelp: function() {
      gShell.println("blink(node)", "Or Alt+B: makes a node blink for a second.", "message");
    },
    
    clearHelp: function() {},
    loadHelp: function() {},
    scopeHelp: function() {},
    
    ans: undefined,
    
    // these two were previously located in `chromeShellExtras.js`
    enumerateWindows: function() {
      var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].
          getService(Components.interfaces.nsIWindowMediator);
      var en = wm.getEnumerator("")
    
      var n = 0;
      gShell.enumWins = [];
      while(en.hasMoreElements()) {
        var w = en.getNext();
        if(w.document.getElementById("content") &&
           w.document.getElementById("content").tagName == "tabbrowser") {
          var b = w.document.getElementById("content");
          var ntabs = b.mPanelContainer.childNodes.length;
          for(var i=0; i<ntabs; i++) {
            var tb = b.getBrowserAtIndex(i);
            try {
              gShell.enumWins[n] = tb.contentWindow;
              printDoScope(tb.currentURI.spec, "gShell.enumWins[" + n + "]");
              n++;
            } catch(e) {}
          }
        }
    
        gShell.enumWins[n] = w;
        printDoScope(w.location.href, "gShell.enumWins[" + n + "]");
        n++;
      }
    },
    
		propsPlus: function(o) {
			for(var x in o) {
				try { 
					var v = o[x];
					if(v instanceof Function) { 
						println(x + ": Function");
					}
					else {
						println(x + ": " + v);
					}
				}
				catch(ex) {}
			}
		}
    
  }, // end gShell.commands
  
  
  /**
   * Initialize the JavaScript shell.
   */
  onLoad: function() {
    if(gShellInitialized == true) {
      return;
    }
    
    gShell._strbundle = document.getElementById("strbundle");
    gShell._output = document.getElementById("output");
    
    // Set top-level scope
    gShell._window = window;
    gShell._window.Shell = window;
    gShell._window.print = gShell.commands.print;
    
    // Create input element
    //gShell.createInputElm();
    
    // Load history service
		// XXX Remade this!!! (to je z historickych duvodu, tak se pridavala dalsi
		//     polozka do seznamu s napovedou)
		var a = document.createElementNS(HTML_NS, "a");
		a.appendChild(document.createTextNode("enumerateWindows()"));
		a.href = "javascript:go('enumerateWindows()')";
		a.setAttribute("accesskey","E");
		
		var odiv = document.getElementById("help-page1").getElementsByTagNameNS(HTML_NS, "p").item(1);
    if((odiv instanceof Components.interfaces.nsIDOMElement)) {
      odiv.appendChild(document.createTextNode(" "));
      odiv.appendChild(a);
    }
		
		// TODO Replace RDF-based storage by SQLite storage
		loadHistory();
    
    gShell.focusInput();
    gShell.recalculateInputHeight();
    
    gShellInitialized = true;
  },
  
  onUnload: function() {
    // Unload history service
    saveHistory();
    releaseRDFService();
  },
  
  recalculateInputHeight: function() {
    var _in = document.getElementById("input");
    
    if((_in instanceof Components.interfaces.nsIDOMElement)) {
      var rows = _in.value.split(/\n/).length + 1;
      
      if(_in.rows != rows) {
        _in.rows = rows;
      }
    }
  },
  
  focusInput: function() {
    gShell.removeInputElm();
    gShell.createInputElm();
    
    var _in = document.getElementById("input");
    
    if((_in instanceof Components.interfaces.nsIDOMElement)) {
      _in.blur(); // Needed for Mozilla to scroll correctly.
      _in.focus();
    }
  },
  
  createInputElm: function() {
    var elm = document.createElementNS(HTML_NS, "textarea");
    
    elm.setAttribute("id", "input");
    elm.setAttribute("class", "input");
    elm.setAttribute("wrap", "off");
    elm.setAttribute("spellcheck", "false");
    elm.setAttribute("onkeypress", "gShell.onInputKeypress(event);");
    elm.setAttribute("rows", "4");
    
    gShell._output.appendChild(elm);
  },
  
  removeInputElm : function() {
    try {
      var cont = document.getElementById("output");
      var elm = document.getElementById("input");
      
      cont.removeChild(elm);
    } catch(e) {}
  },
  
  /**
   * Unless the user is selected something, refocus the textbox.
   * (requested by caillon, brendan, asa).
   * 
   * @param {Components.interfaces.nsIDOMElement}
   */
  keepFocusInTextbox: function(aEvent) {
    var g = aEvent.target;
    
    while(!g.tagName) 
      g = g.parentNode;
    
    var t = g.tagName.toUpperCase();
    if(g.tagName.toUpperCase() == "A" || g.tagName.toUpperCase() == "INPUT")
      return;
    
    if(String(window.getSelection()))
      return;
    
    gShell.focusInput();
  },
  
  /**
   * Fired when user pressed any key on input textarea.
   * @param {Components.interfaces.nsIDOMElement}
   * @returns {void}
   */
  onInputKeypress: function(aEvent) {
    var _in = document.getElementById("input");
    
    if(aEvent.shiftKey && aEvent.keyCode == 13) { // shift-enter
      // don't do anything; allow the shift-enter to insert a line break as normal
    }
    else if(aEvent.keyCode == 13) { // enter
      // execute the input on enter
      try {
        go();
      } catch(er) {
        gShell.printError(er);
      }
      setTimeout(function() {
        // can't preventDefault on input, so clear it later
        document.getElementById("input").value = "";
      }, 0);
    }
    else if(aEvent.keyCode == 38) { // up
      // go up in history if at top or ctrl-up
      if(aEvent.ctrlKey || gShell.caretInFirstLine()) {
        hist(true);
      }
    }
    else if(aEvent.keyCode == 40) { // down
      // go down in history if at end or ctrl-down
      if(aEvent.ctrlKey || gShell.caretInLastLine()) {
        hist(false);
      }
    }
    else if(aEvent.keyCode == 9) { // tab
      tabcomplete();
      setTimeout(function() {
        gShell.focusInput()
      }, 0); // refocus because tab was hit
    }
    
    setTimeout(function() {
      gShell.recalculateInputHeight();
    }, 0);
  },
  
  /**
   * If returns TRUE carret is in the first line of the input textarea.
   * @returns {boolean}
   */
  caretInFirstLine: function() {
    var _in = document.getElementById("input");
    
    if((_in instanceof Components.interfaces.nsIDOMElement)) {
      var firstLineBreak = _in.value.indexOf("\n");
      return ((firstLineBreak == -1) || (_in.selectionStart <= firstLineBreak));
    }
    
    return false;
  },
  
  /**
   * If returns TRUE carret is in the last line of the input textarea.
   * @returns {boolean}
   */
  caretInLastLine: function() {
    var _in = document.getElementById("input");
    
    if((_in instanceof Components.interfaces.nsIDOMElement)) {
      var lastLineBreak = _in.value.lastIndexOf("\n");
      return (_in.selectionEnd > lastLineBreak);
    }
    
    return false;
  },
  
  println: function(s, type) {
    if((s=String(s))) { // ??? Co presne dela tahle podinka?
      var newdiv = document.createElementNS(HTML_NS, "div"); // div
      newdiv.appendChild(document.createTextNode(s));
      newdiv.className = (type == null || type == "") ? "normalOutput" : type;
      gShell._output.appendChild(newdiv);
      
      return newdiv;
    }
    
    return null;
  },
  
  printWithRunin: function(h, s, type) {
    var div = gShell.println(s, type);
    var head = document.createElement("strong");
    
    head.appendChild(document.createTextNode(h + ": "));
    div.insertBefore(head, div.firstChild);
  },
  
  printQuestion: function(q) {
    gShell.println(q, "input");
  },
  
  printAnswer: function(a) {
    if(a !== undefined) {
      gShell.println(a, "normalOutput");
      gShell.commands.ans = a;
    }
  },
  
  printError: function(er) {
    gShell.println(er, "error"); // Because security errors in Moz /only/ have toString.
  },
  
  /**
   * Toggle visibility of help pane
   * @returns {void}
   */
  toggleQuickHelp: function() {
    var helpcont = document.getElementById("quickhelp-cont");
    
    if((helpcont instanceof Components.interfaces.nsIDOMElement)) {
      helpcont.collapsed = !helpcont.collapsed;
    }
  }, // end toggleQuickHelp()
  
  goToHelpTopic: function(aEvent) {
    var target = aEvent.originalTarget;
    
    if(!target) return;
    
    Components.utils.reportError(target.nodeName.toLowerCase());
    
    if(target.nodeName.toLowerCase() != "html:code") return;
    if(!target.hasAttribute("value")) return;
    
    Components.utils.reportError(target.getAttribute("value"));
    
    switch(target.getAttribute("value").toLowerCase()) {
      case "ans": // The result of the previous expression.
        gShell.commands.ansHelp();
        break;
      
      case "blink": // Or Alt+B: makes a node blink for a second.
        gShell.commands.blinkHelp();
        break;
      
      case "clear": // Clears shell
        gShell.commands.clearHelp();
        break;
      
      case "load": //
        gShell.commands.loadHelp();
        break;
      
      case "math":
        // Constants: E, LN2, LN10, LOG2E, LOG10E, PI, SQRT1_2, SQRT2
        // Methods:   abs, acos, asin, atan, atan2, ceil, cos, exp, floor,
        //            log, max, min, pow, random, round, sin, sqrt, tan
        gShell.commands.mathHelp();
        break;
      
      case "pr":
        // Prints and returns its input, so you can use it to print 
        // intermediate results in the middle of an expression.
        //   function fact(n) { return n>0 ? pr(n*fact(n-1)) : 1 }
        gShell.commands.prHelp();
        break;
      
      case "print":
        // Prints expr on its own line.
        //   for(i = 0; i < 6; ++i) print(i * i)
        gShell.commands.printHelp();
        break;
      
      case "props":
        // Or Alt+P: lists the methods and fields of an object.
        // In Firefox, props also shows which properties belong to the object
        // itself and which belong to objects in its prototype chain.
        gShell.commands.propsHelp();
        break;
      
      case "scope":
        // Set given object as the current scope.
        //   scope(Math); // we are now can write abs instead of Math.abs
        gShell.commands.scopeHelp();
        break;
      
      // Links
      case "#about":
      case "#features":
      case "#functions":
      case "usage":
        break;
    }
  } // end goToHelpTopic(aEvent)
  
}; // End of gShell


// ===========================================================================


function hist(up)
{
  var _in = document.getElementById("input");
  
  // histList[0] = first command entered, [1] = second, etc.
  // type something, press up --> thing typed is now in "limbo"
  // (last item in histList) and should be reachable by pressing 
  // down again.

  var L = gShell.histList.length;

  if(L == 1)
    return;

  if(up) {
    if(gShell.histPos == L-1) {
      // Save this entry in case the user hits the down key.
      gShell.histList[gShell.histPos] = _in.value;
    }

    if(gShell.histPos > 0) {
      gShell.histPos--;
      // Use a timeout to prevent up from moving cursor within new text
      // Set to nothing first for the same reason
      setTimeout(
        function() {
          _in.value = ''; 
          _in.value = gShell.histList[gShell.histPos];
          var caretPos = _in.value.length;
          if(_in.setSelectionRange) {
            _in.setSelectionRange(caretPos, caretPos);
          }
        },
        0
      );
    }
  } 
  else // down
  {
    if(gShell.histPos < L-1) {
      gShell.histPos++;
      _in.value = gShell.histList[gShell.histPos];
    }
    else if(gShell.histPos == L-1) {
      // Already on the current entry: clear but save
      if(_in.value) {
        gShell.histList[gShell.histPos] = _in.value;
        ++gShell.histPos;
        _in.value = "";
      }
    }
  }
}

function tabcomplete()
{
  /*
   * Working backwards from s[from], find the spot
   * where this expression starts.  It will scan
   * until it hits a mismatched ( or a space,
   * but it skips over quoted strings.
   * If stopAtDot is true, stop at a '.'
   */
  function findbeginning(s, from, stopAtDot) {
    /*
     *  Complicated function.
     *
     *  Return true if s[i] == q BUT ONLY IF
     *  s[i-1] is not a backslash.
     */
    function equalButNotEscaped(s,i,q)
    {
      if(s.charAt(i) != q) // not equal go no further
        return false;

      if(i==0) // beginning of string
        return true;

      if(s.charAt(i-1) == '\\') // escaped?
        return false;

      return true;
    }

    var nparens = 0;
    var i;
    for(i=from; i>=0; i--)
    {
      if(s.charAt(i) == ' ')
        break;

      if(stopAtDot && s.charAt(i) == '.')
        break;
        
      if(s.charAt(i) == ')')
        nparens++;
      else if(s.charAt(i) == '(')
        nparens--;

      if(nparens < 0)
        break;

      // skip quoted strings
      if(s.charAt(i) == '\'' || s.charAt(i) == '\"')
      {
        //dump("skipping quoted chars: ");
        var quot = s.charAt(i);
        i--;
        while(i >= 0 && !equalButNotEscaped(s,i,quot)) {
          //dump(s.charAt(i));
          i--;
        }
        //dump("\n");
      }
    }
    return i;
  }

  // XXX should be used more consistently (instead of using selectionStart/selectionEnd throughout code)
  // XXX doesn't work in IE, even though it contains IE-specific code
  function getcaretpos(inp)
  {
    if(inp.selectionEnd != null)
      return inp.selectionEnd;
      
    if(inp.createTextRange)
    {
      var docrange = gShell._window.Shell.document.selection.createRange();
      var inprange = inp.createTextRange();
      if (inprange.setEndPoint)
      {
        inprange.setEndPoint('EndToStart', docrange);
        return inprange.text.length;
      }
    }

    return inp.value.length; // sucks, punt
  }

  function setselectionto(inp,pos)
  { 
    if(inp.selectionStart) {
      inp.selectionStart = inp.selectionEnd = pos;
    }
    else if(inp.createTextRange) {
      var docrange = gShell._window.Shell.document.selection.createRange();
      var inprange = inp.createTextRange();
      inprange.move('character',pos);
      inprange.select();
    }
    else { // err...
      /*
      inp.select();
      if(gShell._window.Shell.document.getSelection()) {
        gShell._window.Shell.document.getSelection() = "";
      }
      */
    }
  }
  
  var _in = document.getElementById("input");

  // get position of cursor within the input box
  var caret = getcaretpos(_in);

  if(caret) {
    //dump("----\n");
    var dotpos, spacepos, complete, obj;
    //dump("caret pos: " + caret + "\n");
    // see if there's a dot before here
    dotpos = findbeginning(_in.value, caret-1, true);
    //dump("dot pos: " + dotpos + "\n");
    if(dotpos == -1 || _in.value.charAt(dotpos) != '.') {
      dotpos = caret;
      //dump("changed dot pos: " + dotpos + "\n");
    }

    // look backwards for a non-variable-name character
    spacepos = findbeginning(_in.value, dotpos-1, false);
    //dump("space pos: " + spacepos + "\n");
    // get the object we're trying to complete on
    if(spacepos == dotpos || spacepos+1 == dotpos || dotpos == caret)
    {
      // try completing function args
      if(_in.value.charAt(dotpos) == '(' ||
         (_in.value.charAt(spacepos) == '(' && (spacepos+1) == dotpos))
      {
        var fn,fname;
        var from = (_in.value.charAt(dotpos) == '(') ? dotpos : spacepos;
        spacepos = findbeginning(_in.value, from-1, false);

        fname = _in.value.substr(spacepos+1,from-(spacepos+1));
        //dump("fname: " + fname + "\n");
        
        try {
          with(gShell._window.Shell.scope) {
            with(gShell._window) {
              with(gShell.commands) {
                fn = eval(fname);
              }
            }
          }
        }
        catch(er) {
          //dump('fn is not a valid object\n');
          return;
        }
        if(fn == undefined) {
           //dump('fn is undefined');
           return;
        }
        if(fn instanceof Function)
        {
          // Print function definition, including argument names, but not function body
          if(!fn.toString().match(/function .+?\(\) +\{\n +\[native code\]\n\}/)) {
            gShell.println(fn.toString().match(/function .+?\(.*?\)/), "tabcomplete");
          }
        }

        return;
      }
      else
        obj = gShell._window;
    }
    else
    {
      var objname = _in.value.substr(spacepos+1,dotpos-(spacepos+1));
      //dump("objname: |" + objname + "|\n");
      try {
        with(gShell._window.Shell.scope) {
          with(gShell._window) {
            obj = eval(objname);
          }
        }
      } catch(er) {
        gShell.printError(er); 
        return;
      }
      if(obj == undefined) {
        // sometimes this is tabcomplete's fault, so don't print it :(
        // e.g. completing from "print(document.getElements"
        // gShell.println("Can't complete from null or undefined expression " + objname, "error");
        return;
      }
    }
    //dump("obj: " + obj + "\n");
    // get the thing we're trying to complete
    if(dotpos == caret)
    {
      if(spacepos+1 == dotpos || spacepos == dotpos)
      {
        // nothing to complete
        //dump("nothing to complete\n");
        return;
      }

      complete = _in.value.substr(spacepos+1,dotpos-(spacepos+1));
    }
    else {
      complete = _in.value.substr(dotpos+1,caret-(dotpos+1));
    }
    //dump("complete: " + complete + "\n");
    // ok, now look at all the props/methods of this obj
    // and find ones starting with 'complete'
    var matches = [];
    var bestmatch = null;
    
    for(var a in obj) {
      //a = a.toString();
      //XXX: making it lowercase could help some cases,
      
      // but screws up my general logic.
      if(a.substr(0,complete.length) == complete) {
        matches.push(a);
        
        // if no best match, this is the best match
        if(bestmatch == null) {
          bestmatch = a;
        }
        else {
          // the best match is the longest common string
          function min(a,b){ return ((a<b)?a:b); }
          
          var i;
          for(i=0; i< min(bestmatch.length, a.length); i++) 
            if(bestmatch.charAt(i) != a.charAt(i))
              break;
          
          bestmatch = bestmatch.substr(0,i);
        }
      }
    }
    bestmatch = (bestmatch || "");
    
    var objAndComplete = (objname || obj) + "." + bestmatch;
    
    if(matches.length > 1 &&
       (gShell.tooManyMatches == objAndComplete || matches.length <= 10)) {
      gShell.printWithRunin("Matches: ", matches.join(', '), "tabcomplete");
      gShell.tooManyMatches = null;
    }
    else if(matches.length > 10) {
      gShell.println(matches.length + " matches.  Press tab again to see them all", "tabcomplete");
      gShell.tooManyMatches = objAndComplete;
    }
    else {
      gShell.tooManyMatches = null;
    }
    if(bestmatch != "") {
      var sstart;
      
      if(dotpos == caret) {
        sstart = spacepos+1;
      }
      else {
        sstart = dotpos+1;
      }
      
      _in.value = _in.value.substr(0, sstart)
                + bestmatch
                + _in.value.substr(caret);
      setselectionto(_in,caret + (bestmatch.length - complete.length));
    }
  }
}

function go(s)
{
  var _in = document.getElementById("input");
  
  _in.value = gShell.question = s ? s : _in.value;

  if (gShell.question == "")
    return;

  gShell.histList[gShell.histList.length-1] = gShell.question;
  gShell.histList[gShell.histList.length] = "";
  gShell.histPos = gShell.histList.length - 1;
  
  // Unfortunately, this has to happen *before* the JavaScript is run, so that 
  // print() output will go in the right place.
  _in.value = '';
  gShell.recalculateInputHeight();
  gShell.printQuestion(gShell.question);
  
  if(gShell._window.closed) {
    gShell.printError("Target window has been closed.");
    return;
  }
  
  try { ("Shell" in gShell._window) }
  catch(er) {
    gShell.printError("The JavaScript Shell cannot access variables in the target window.  The most likely reason is that the target window now has a different page loaded and that page has a different hostname than the original page.");
    return;
  }

  if(!("Shell" in gShell._window)) {
    gShell.initializeShell(); // silent
  }
  
  // Evaluate Shell.question using _win's eval (this is why eval isn't in the |with|, IIRC).
  gShell._window.location.href =
      "javascript:" +
      "try {" +
      "  gShell.printAnswer(eval('with(gShell.scope) with(gShell.commands) {' + gShell.question + String.fromCharCode(10) + '}'));" +
      "} catch(er) {" +
      "  gShell.printError(er);" +
      "};" +
      "setTimeout(gShell.focusInput, 0);" +
      "void 0";
}


// ===========================================================================
// Previously located in `chromeShellExtras.js`

function printDoScope(s, scopeObjText)
{
  var newdiv = document.createElementNS(HTML_NS, "div");
  var a = document.createElementNS(HTML_NS, "a");
  
	a.href = "javascript:go('scope(" + scopeObjText + ")')";
  a.appendChild(document.createTextNode(s));
	
  newdiv.appendChild(a);
  newdiv.className = "normalOutput";
  gShell._output.appendChild(newdiv);
  
	return newdiv;
}

function loadHistory()
{
  var items = loadHistoryItems("http://ted.mielczarek.org/code/mozilla/extensiondev#jsshell_history", "http://ted.mielczarek.org/code/mozilla/extensiondev#jsshell_historyitem");
  gShell.histList = items;
  
	if(gShell.histList[gShell.histList.length-1] != "") {
    gShell.histList.push("");
	}
	
  gShell.histPos = (gShell.histList.length > 0) ? gShell.histList.length-1 : 0;
}

function saveHistory()
{
  var num = min(gShell.histList.length, 20 + 1);
  var start = gShell.histList.length - num;
  
  saveHistoryItems(gShell.histList.slice(start, gShell.histList.length), "http://ted.mielczarek.org/code/mozilla/extensiondev#jsshell_history", "http://ted.mielczarek.org/code/mozilla/extensiondev#jsshell_historyitem");
}


// ===========================================================================
// Add on load/unload event handlers

window.addEventListener("load", gShell.onLoad, true);
window.addEventListener("unload", gShell.onUnload, true);
