<?
//   XUL Webmail, a web based mailclient
//
//   Copyright (C) 2004 Wouter van Wijk (wvw@dds.nl),
//   based on XUL Channels, Copyright (C) 2003 Tim Broddin
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// session check
session_start();
if (!isset($_SESSION['user']))
{
	header("Location: error.rdf.php?ec=2");
	exit;
}
header('Content-type: text/rdf; charset=iso-8859-15');
header ("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header ("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header ("Cache-Control: no-cache, must-revalidate");
header ("Pragma: no-cache");

echo '<' . '?xml version="1.0" encoding="iso-8859-15" ?' . '>';
include('settings.php');
?>

<RDF:RDF xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:MAILBOXES="http://www.xulwebmail.com/rdf/mailboxlist#">

 <?
 	$mailboxlist = getMailboxes();

	// iterate through mailboxes to build the rdf-descriptions
	foreach ($mailboxlist as $value) {
		$string1 .= '<RDF:Description about="' . makeXML(htmlspecialchars($value['id'])) . "\">\n";
		$string1 .= '<MAILBOXES:name>'. makeXML(htmlspecialchars($value['name'])) . "</MAILBOXES:name>\n";
		$string1 .= '<MAILBOXES:icon>'. makeXML(htmlspecialchars($value['icon'])) . "</MAILBOXES:icon>\n";
		$string1 .= '<MAILBOXES:id>' . makeXML(htmlspecialchars($value['id'])) . "</MAILBOXES:id>\n";
		$string1 .= "</RDF:Description>\n\n";
	}

	function buildtree ($ischildof, $mb) {
		// iterate through mailboxes
		foreach ($mb as $value) {
			if ($value['childof'] == $ischildof) {
//			echo $value['childof'] . '-' . $ischildof . "\n";
				//recurse for children
				$children = buildtree ($value['id'], $mb);
				if ($children !=   '') {
					$result .= '<RDF:Seq about="'.makeXML(htmlspecialchars($value['id']))."\"><RDF:li>\n";
					$result .= $children;
					$result .= '</RDF:li></RDF:Seq>' . "\n";
				} else {
					$result .= '<RDF:li about="'.makeXML(htmlspecialchars($value['id']))."\" />\n";
				}
			}
		}
		return($result);
	}
	echo $string1. "\n\n";
	echo '<RDF:Seq about="http://www.xulwebmail.com/rdf/mblist"><RDF:li>' . "\n";
	echo buildtree(-1, $mailboxlist);
	echo '</RDF:li></RDF:Seq>' . "\n";
 ?>

</RDF:RDF>
