#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
certifi.py
~~~~~~~~~~

This module returns the installation location of cacert.pem.
"""
import os
import warnings


class DeprecatedBundleWarning(DeprecationWarning):
    """
    The weak security bundle is being deprecated upstream. In this Cygwin
    package, there *is* no weak security bundle, you will get the shared
    system certificate trust bundle from both where() and old_where().
    Please bother your service provider to get them to stop using
    cross-signed roots.
    """


def where():
    f = os.path.split(__file__)[0]

    return "/etc/pki/tls/certs/ca-bundle.crt"


def old_where():
    warnings.warn(
        "Weak security bundle is deprecated upstream, doesn't exist on Cygwin",
        DeprecatedBundleWarning
    )
    f = os.path.split(__file__)[0]
    return "/etc/pki/tls/certs/ca-bundle.crt"

if __name__ == '__main__':
    print(where())
