// <bits/loccore.tcc>

// Locale support -*- C++ -*-

// Copyright (C) 1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

/* Warning: this file is not meant for user inclusion.  Use <locale>. */

#ifndef _CPP_BITS_LOCCORE_TCC
#define _CPP_BITS_LOCCORE_TCC 1

namespace std
{

#if defined(_G_NO_TEMPLATE_EXPORT) && !defined(export)
#define export 
#endif

  export template<typename _Facet>
    locale::locale (const locale& __other, _Facet* __f)
  {
    _M_impl = new _Impl (*__other._M_impl, 0);
    _M_impl->_M_install_facet (&_Facet::id, __f);
    _M_impl->_M_has_name = false;
  }

  export template<typename _Facet>
    locale locale::combine (const locale& __other)
  {
    locale __copy (*this);
    __copy._M_impl->_M_replace_facet (__other._M_impl, &_Facet::id);
    __copy._M_impl->_M_has_name = false;
    return __copy;
  }

  export template<typename _CharT, typename _Traits, typename _Alloc>
    bool
    locale::operator() (const basic_string<_CharT,_Traits,_Alloc>& __s1,
			const basic_string<_CharT,_Traits,_Alloc>& __s2) const
  {
    return use_facet< std::collate<_CharT> > (*this) (
       __s1.data (), __s1.data ()+__s1.length (),
       __s2.data (), __s2.data ()+__s2.length ()) < 0;
  }

} // std::

#endif /* _CPP_BITS_LOCCORE_TCC */

// Local Variables:
// mode:c++
// End:
