// The template and inlines for the -*- C++ -*- mask_array class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_BITS_MASK_ARRAY_H
#define _CPP_BITS_MASK_ARRAY_H

namespace std {

template <class _T> class mask_array
{ 
public:
    typedef _T value_type;
    
    void operator=  (const valarray<_T>&) const;
    void operator*= (const valarray<_T>&) const;
    void operator/= (const valarray<_T>&) const;
    void operator%= (const valarray<_T>&) const;
    void operator+= (const valarray<_T>&) const; 
    void operator-= (const valarray<_T>&) const;
    void operator^= (const valarray<_T>&) const;  
    void operator&= (const valarray<_T>&) const;
    void operator|= (const valarray<_T>&) const;
    void operator<<=(const valarray<_T>&) const;  
    void operator>>=(const valarray<_T>&) const; 
    void operator= (const _T&);
    
    ~mask_array ();

    template<class _Expr>
      void operator=  (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator*= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator/= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator%= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator+= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator-= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator^= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator&= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator|= (const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator<<=(const _Meta<_Expr,_T>&) const;
    template<class _Expr>
      void operator>>=(const _Meta<_Expr,_T>&) const; 

private:
    mask_array ();
    mask_array (const mask_array&);
    mask_array& operator= (const mask_array&);

    mask_array (_Array<_T>, size_t, _Array<bool>);
    friend class valarray<_T>;

    const size_t       _M_sz;
    const _Array<bool> _M_mask;
    const _Array<_T>   _M_array;
};

template<typename _T>
inline 
mask_array<_T>::mask_array (_Array<_T> __a, size_t __s, _Array<bool> __m)
        : _M_sz (__s), _M_mask (__m), _M_array (__a) {}
    
template<typename _T>
inline mask_array<_T>::~mask_array () {}

template<typename _T>
inline void
mask_array<_T>::operator= (const _T& __t)
  { __valarray_fill (_M_array, _M_sz, _M_mask, __t); }

template<typename _T>
inline void
mask_array<_T>::operator= (const valarray<_T>& __v) const
  { __valarray_copy (_Array<_T> (__v), __v.size (), _M_array, _M_mask); }

template<typename _T>
template<class E>
inline void
mask_array<_T>::operator= (const _Meta<E, _T>& __e) const
  { __valarray_copy (__e, __e.size (), _M_array, _M_mask); }

#undef _DEFINE_VALARRAY_OPERATOR
#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
template<typename _T>							\
inline void								\
mask_array<_T>::operator##op##= (const valarray<_T>& __v) const		\
{									\
  _Array_augmented_##name (_M_array, _M_mask, 				\
                           _Array<_T> (__v), __v.size ());		\
}									\
									\
template<typename _T> template<class E>					\
inline void								\
mask_array<_T>::operator##op##= (const _Meta<E, _T>& __e) const		\
{									\
  _Array_augmented_##name (_M_array, _M_mask, __e, __e.size ());	\
}

_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(+, plus)
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(^, xor)
_DEFINE_VALARRAY_OPERATOR(&, and)
_DEFINE_VALARRAY_OPERATOR(|, or)
_DEFINE_VALARRAY_OPERATOR(<<, shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, shift_right)

#undef _DEFINE_VALARRAY_OPERATOR    
    
} // std::

#endif /* _CPP_BITS_MASK_ARRAY_H */

// Local Variables:
// mode:c++
// End:
