// Output streams -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ working draft paper: 27.6.2  Output streams
//

#ifndef _CPP_OSTREAM
#define _CPP_OSTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/std_streambuf.h>

namespace std {

  template <class _CharT, class _Traits>
  class basic_ostream : virtual public basic_ios<_CharT,_Traits>
  {
  public:
    // Types (inherited from basic_ios (_lib.ios_)):
    typedef _CharT                     char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructor/destructor:
    explicit basic_ostream (basic_streambuf<char_type,_Traits>* __sb)
      : basic_ios<_CharT,_Traits>()  // virtual base, often ignored.
      { this->init (__sb); }
    virtual ~basic_ostream ();

    // Prefix/suffix:
    class sentry;
    friend class sentry;

    // Formatted output:
    basic_ostream<_CharT,_Traits> &
    operator << (basic_ostream<_CharT,_Traits>& (*__pf
      )(basic_ostream<_CharT,_Traits>&))
      {
	__pf (*this);
	return *this;
      }
    basic_ostream<_CharT,_Traits> &
    operator << (basic_ios<_CharT,_Traits>& (*__pf
      ) (basic_ios<_CharT,_Traits>&))
      {
	__pf (*this);
	return *this;
      }
    basic_ostream<_CharT,_Traits> &
    operator << (ios_base& (*__pf) (ios_base&))
      {
	__pf (*this);
	return *this;
      }

    // 27.6.2.5.3  basic_ostream::operator<<
    basic_ostream<_CharT,_Traits>& operator<< (bool __n);
    basic_ostream<_CharT,_Traits>& operator<< (short __n)
      { return operator<<(long(__n)); }
    basic_ostream<_CharT,_Traits>& operator<< (unsigned short __n)
      { return operator<<((unsigned long)__n); }
    basic_ostream<_CharT,_Traits>& operator<< (int __n)
      { return operator<<(long(__n)); }
    basic_ostream<_CharT,_Traits>& operator<< (unsigned int __n)
      { return operator<<((unsigned long)__n); }
    basic_ostream<_CharT,_Traits>& operator<< (long __n);
    basic_ostream<_CharT,_Traits>& operator<< (unsigned long __n);
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
    basic_ostream<_CharT,_Traits>& operator<< (long long __n);
    basic_ostream<_CharT,_Traits>& operator<< (unsigned long long __n);
#endif
    basic_ostream<_CharT,_Traits>& operator<< (float __f)
      { return operator<<(double(__n)); }
    basic_ostream<_CharT,_Traits>& operator<< (double __f);
    basic_ostream<_CharT,_Traits>& operator<< (long double __f);
    basic_ostream<_CharT,_Traits>& operator<< (const void* __p);
    basic_ostream<_CharT,_Traits>& operator<< (
      basic_streambuf<char_type,_Traits>* __sb);

    // Unformatted output:
    // XXX fixme: these need to create sentry objects, for MT safety.
    basic_ostream<_CharT,_Traits>& put (char_type __c)
      { rdbuf ()->sputc (__c); return *this; }
    basic_ostream<_CharT,_Traits>& write (const char_type* __s,
					  streamsize __n);
    basic_ostream<_CharT,_Traits>& flush ();

    // Seeks:
    pos_type tellp ();
    basic_ostream<_CharT,_Traits>& seekp (pos_type);
    basic_ostream<_CharT,_Traits>& seekp (off_type, ios_base::seekdir);

  private:
    void _M_do_osfx ();
  };

  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>::~basic_ostream() {}

  // 27.6.2.3  Class basic_ostream::sentry
  template <class _CharT, class _Traits>
  class basic_ostream<_CharT,_Traits>::sentry
  {
    bool _M_ok;
    class basic_ostream<_CharT,_Traits>& _M_ostr;

  public:
    explicit sentry (basic_ostream<_CharT,_Traits>& __os)
      : _M_ok (__os.good ()), _M_ostr (__os)
      {
	// XXX MT
	if (_M_ok && __os.tie ())
	  __os.tie ()->flush ();  // XXX try to avoid calling this.
      }
    ~sentry ()
      {
	// XXX MT
	if (_M_ostr.flags () & ios_base::unitbuf && // XXX ios_base::stdio?
            !uncaught_exception())
	  _M_ostr._M_do_osfx ();
      }
    operator bool () { return _M_ok; }
  };

  // XXX the definitions below should be moved to ostream.tcc.

  // Character inserters
  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits> &
  operator << (basic_ostream<_CharT,_Traits>& __out, _CharT __c)
  {
    // XXX need sentry
    return __out.put (__c);
  }

  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits> &
  operator << (basic_ostream<_CharT,_Traits>& __out, char __c)
  {
    // XXX need sentry
    return __out.put (widen (__c));
  }


  // Specialization
  template <class _Traits>
  basic_ostream<char,_Traits> &
  operator << (basic_ostream<char,_Traits>& __out, char __c)
  {
    // XXX need sentry
    return __out.put (__c);
  }


  // Signed and unsigned
  template <class _Traits>
  basic_ostream<char,_Traits> &
  operator << (basic_ostream<char,_Traits>& __out, signed char __c)
  {
    // XXX need sentry
    return __out.put (static_cast<char> (__c));
  }

  template <class _Traits>
  basic_ostream<char,_Traits> &
  operator << (basic_ostream<char,_Traits>& __out, unsigned char __c)
  {
    // XXX need sentry
    return __out.put (static_cast<char> (__c));
  }

  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits> &
  operator << (basic_ostream<_CharT,_Traits>& __out, const _CharT* __s)
  {
    // XXX need sentry
    return __out.write (__s,_Traits::length (__s));
  }

  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits> &
  operator << (basic_ostream<_CharT,_Traits>& __out, const char* __s)
  {
    // XXX need sentry
    // XXX should narrow, not cast.
    return __out.write (static_cast<const _CharT*> (__s),
		      _Traits::length (static_cast<const _CharT*> (__s)));
  }

  // Partial specializationss
  template<class _Traits>
  basic_ostream<char,_Traits> &
  operator << (basic_ostream<char,_Traits>& __out, const char* __s)
  {
    // XXX need sentry
    return __out.write (__s,_Traits::length (__s));
  }

  // Signed and unsigned
  template<class _Traits>
  basic_ostream<char,_Traits> &
  operator << (basic_ostream<char,_Traits>& __out, const signed char* __s)
  {
    // XXX need sentry
    return __out.write (static_cast<const char*> (__s),
		      _Traits::length (static_cast<const char*> (__s)));
  }

  template<class _Traits>
  basic_ostream<char,_Traits> &
  operator << (basic_ostream<char,_Traits>& __out, const unsigned char* __s)
  {
    // XXX need sentry
    return __out.write (static_cast<const char*> (__s),
		      _Traits::length (static_cast<const char*> (__s)));
  }


    // XXX need sentry
  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& endl (basic_ostream<_CharT,_Traits>& __os)
    { return flush (__os.put (__os.widen ('\n'))); }

    // XXX need sentry
  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& ends (basic_ostream<_CharT,_Traits>& __os)
    { return __os.put (_Traits::eos ()); }

    // XXX need sentry
  template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& flush (basic_ostream<_CharT,_Traits>& __os)
    { return __os.flush (); }



} // namespace std

#ifdef _G_NO_TEMPLATE_EXPORT
# define export
# include <bits/ostream.tcc>
#endif

#endif	/* _CPP_OSTREAM */
