/* Complex sine hyperbole function for long double.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ long double
csinhl (__complex__ long double x)
{
  __complex__ long double retval;
  int negate = signbit (__real__ x);

  __real__ x = fabsl (__real__ x);

  if (FINITEL_P (__real__ x))
    {
      /* Real part is finite.  */
      if (FINITEL_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  long double sinh_val = sinhl (__real__ x);
	  long double cosh_val = coshl (__real__ x);
	  long double sinix = sinl (__imag__ x);
	  long double cosix = cosl (__imag__ x);

	  __real__ retval = sinh_val * cosix;
	  __imag__ retval = cosh_val * sinix;

	  if (negate)
	    __real__ retval = -__real__ retval;
	}
      else
	{
	  if (__real__ x == 0.0)
	    {
	      /* Real part is 0.0.  */
	      __real__ retval = __copysignl (0.0, negate ? -1.0 : 1.0);
	      __imag__ retval = NAN + NAN;
	    }
	  else
	    {
	      __real__ retval = NAN;
	      __imag__ retval = NAN;
	    }
	}
    }
  else if (INFINITEL_P (__real__ x))
    {
      /* Real part is infinite.  */
      if (__imag__ x == 0.0)
	{
	  /* Imaginary part is 0.0.  */
	  __real__ retval = negate ? -HUGE_VALL : HUGE_VALL;
	  __imag__ retval = __imag__ x;
	}
      else if (FINITEL_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  long double sinix = sinl (__imag__ x);
	  long double cosix = cosl (__imag__ x);

	  __real__ retval = __copysignl (HUGE_VALL, cosix);
	  __imag__ retval = __copysignl (HUGE_VALL, sinix);

	  if (negate)
	    __real__ retval = -__real__ retval;
	}
      else
	{
	  /* The addition raises the invalid exception.  */
	  __real__ retval = HUGE_VALL;
	  __imag__ retval = NAN + NAN;
	}
    }
  else
    {
      __real__ retval = NAN;
      __imag__ retval = __imag__ x == 0.0 ? __imag__ x : NAN;
    }

  return retval;
}
