// Methods for Exception Support for -*- C++ -*-


// Copyright (C) 1994-1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Mike Stump based upon the specification in the 20 September 1994
// C++ working paper, ANSI document X3J16/94-0158.

//
// ISO C++ draft working paper:	19.1  Exception classes
//

#include <bits/std_string.h>
#include <bits/std_stdexcept.h>

// To break the circularity with the <stdexcept> and <string> header we
// define two functions which throw exceptions as a direct call would do.

void
__out_of_range (const char *str)
{
  throw out_of_range (str);
}


void __length_error (const char *str)
{
  throw length_error (str);
}

#if 0
namespace std {

const char* logic_error::what() const throw() {
  return (__msg.c_str());
}

const char* runtime_error::what() const throw() {
  return (__msg.c_str());
}

} //namespace std
#endif

