-- THIS GENERIC PROCEDURE IS INTENDED FOR USE IN CONJUNCTION WITH THE ACVC
-- CHAPTER 13 C TESTS. IT IS INSTANTIATED WITH TWO TYPES. THE FIRST IS AN
-- ENUMERATION TYPE FOR WHICH AN ENUMERATION CLAUSE HAS BEEN GIVEN, AND THE
-- SECOND IS AN INTEGER TYPE WHOSE 'SIZE IS THE SAME AS THE 'SIZE OF THIS
-- ENUMERATION TYPE.

-- THE PROCEDURE ENUM_CHECK IS THEN CALLED WITH THREE ARGUMENTS. THE FIRST IS
-- AN ENUMERATION LITERAL FROM THE ENUMERATION TYPE, THE SECOND IS AN INTEGER
-- LITERAL WHICH IS THE VALUE OF THE EXPECTED REPRESENTATION (TAKEN FROM THE
-- ENUMERATION REPRESENTATION CLAUSE), AND THE THIRD IS A STRING DESCRIBING OR
-- NAMING THE TYPE (USED IN A CALL TO FAILED IF THE REPRESENTATION CHECK FAILS).

-- THE CHECK IS TO CONVERT THE ENUMERATION VALUE TO A BOOLEAN ARRAY WITH A
-- LENGTH CORRESONDING TO THE 'SIZE OF THE ENUMERATION TYPE. AN INTEGER TYPE
-- IS THEN CREATED WITH THIS SAME 'SIZE, AND THE REQUIRED REPRESENTATION VALUE
-- IS CONVERTED FROM THIS TYPE TO A BOOLEAN ARRAY WITH THE SAME LENGTH. THE
-- TWO BOOLEAN ARRAYS ARE THEN COMPARED AND SHOULD BE EQUAL. THE CONVERSIONS
-- ARE PERFORMED USING APPROPRIATE INSTANTIATIONS OF UNCHECKED_CONVERSION.

-- AUTHOR: ROBERT B. K. DEWAR, UNCOPYRIGHTED, PUBLIC DOMAIN USE AUTHORIZED

GENERIC

   TYPE ENUM_TYPE IS PRIVATE;
   TYPE INT_TYPE IS RANGE <>;

PROCEDURE ENUM_CHECK (TEST_VALUE : ENUM_TYPE;
		      REP_VALUE  : INT_TYPE;
		      TYPE_ID	 : STRING);


WITH UNCHECKED_CONVERSION;
WITH REPORT; USE REPORT;

PROCEDURE ENUM_CHECK (TEST_VALUE : ENUM_TYPE;
		      REP_VALUE  : INT_TYPE;
		      TYPE_ID	 : STRING) IS

   TYPE BIT_ARRAY_TYPE IS ARRAY (1 .. ENUM_TYPE'SIZE) OF BOOLEAN;
   PRAGMA PACK (BIT_ARRAY_TYPE);

   FUNCTION TO_BITS IS NEW UNCHECKED_CONVERSION (ENUM_TYPE, BIT_ARRAY_TYPE);
   FUNCTION TO_BITS IS NEW UNCHECKED_CONVERSION (INT_TYPE, BIT_ARRAY_TYPE);

   BIT_ARRAY_1 : BIT_ARRAY_TYPE;
   BIT_ARRAY_2 : BIT_ARRAY_TYPE;

   INT_VALUE : INT_TYPE := INT_TYPE (REP_VALUE);

BEGIN

   -- VERIFY CORRECT CALL (THIS IS A SANITY CHECK ON THE TEST ITSELF)

   IF ENUM_TYPE'SIZE /= INT_TYPE'SIZE THEN
      FAILED ("ERROR IN ENUM_CHECK CALL: SIZES DO NOT MATCH");
   END IF;

   BIT_ARRAY_1 := TO_BITS (TEST_VALUE);
   BIT_ARRAY_2 := TO_BITS (INT_VALUE);

   IF BIT_ARRAY_1 /= BIT_ARRAY_2 THEN
      FAILED ("CHECK ON REPRESENTATION OF TYPE " & TYPE_ID & " FAILED.");
   END IF;

END ENUM_CHECK;
