/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class InnerClassesAttribute
extends Attribute {
    List classes = new LinkedList();

    InnerClassesAttribute(short nameIndex, DataInputStream dis) throws IOException {
        super(nameIndex);
        int count = dis.readShort();
        for (int i = 0; i < count; ++i) {
            short inner_class_info_index = dis.readShort();
            short outer_class_info_index = dis.readShort();
            short inner_name_index = dis.readShort();
            short inner_class_access_flags = dis.readShort();
            this.classes.add(new InnerClass(inner_class_info_index, outer_class_info_index, inner_name_index, inner_class_access_flags));
        }
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.classes.size());
            for (InnerClass ic : this.classes) {
                dos.writeShort(ic.getInnerClassInfoIndex());
                dos.writeShort(ic.getOuterClassInfoIndex());
                dos.writeShort(ic.getInnerNameIndex());
                dos.writeShort(ic.getInnerClassAccessFlags());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public class InnerClass {
        private short inner_class_info_index;
        private short outer_class_info_index;
        private short inner_name_index;
        private short inner_class_access_flags;

        public InnerClass(short inner_class_info_index, short outer_class_info_index, short inner_name_index, short inner_class_access_flags) {
            this.inner_class_info_index = inner_class_info_index;
            this.outer_class_info_index = outer_class_info_index;
            this.inner_name_index = inner_name_index;
            this.inner_class_access_flags = inner_class_access_flags;
        }

        public short getInnerClassInfoIndex() {
            return this.inner_class_info_index;
        }

        public short getOuterClassInfoIndex() {
            return this.outer_class_info_index;
        }

        public short getInnerNameIndex() {
            return this.inner_name_index;
        }

        public short getInnerClassAccessFlags() {
            return this.inner_class_access_flags;
        }
    }
}

