//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <memory>

// unique_ptr

// Test unique_ptr(pointer) ctor

// unique_ptr<T[]>(pointer) ctor should only require default Deleter ctor

#include <memory>
#include <cassert>

struct A
{
    static int count;
    A() {++count;}
    A(const A&) {++count;}
    ~A() {--count;}
};

int A::count = 0;

class Deleter
{
    int state_;

    Deleter(Deleter&);
    Deleter& operator=(Deleter&);

public:
    Deleter() : state_(5) {}

    int state() const {return state_;}

    void operator()(A* p) {delete [] p;}
};

int main()
{
    {
    A* p = new A[3];
    assert(A::count == 3);
    std::unique_ptr<A[]> s(p);
    assert(s.get() == p);
    }
    assert(A::count == 0);
    {
    A* p = new A[3];
    assert(A::count == 3);
    std::unique_ptr<A[], Deleter> s(p);
    assert(s.get() == p);
    assert(s.get_deleter().state() == 5);
    }
    assert(A::count == 0);
}
